# 🔐 رفع کامل مشکل احراز هویت - تزریق خودکار Token

## 🎯 مشکل اصلی

کاربر بعد از لاگین، Token در localStorage ذخیره می‌شد، ولی:
- ❌ وقتی به صفحات دیگه میرفت، Token از localStorage خوانده **نمی‌شد**
- ❌ Session در موبایل/WebView به خوبی حفظ **نمی‌شد**
- ❌ در نتیجه کاربر باید **دوباره لاگین** می‌کرد

## ✅ راه‌حل نهایی

### 1. تغییر تابع `requireLogin()` در `config/config.php`

تابع `requireLogin()` حالا یک متغیر global به نام `$requireAuth` ست می‌کنه:

```php
function requireLogin() {
    // Set global flag that this page requires authentication
    global $requireAuth;
    $requireAuth = true;
    
    if (!isLoggedIn()) {
        header('Location: /login.php');
        exit;
    }
}
```

### 2. تزریق خودکار Token در `includes/header.php`

یک اسکریپت JavaScript در `<head>` اضافه شد که **خیلی زود** اجرا میشه:

```javascript
<?php if (isset($requireAuth) && $requireAuth === true): ?>
<script>
    // این اسکریپت برای صفحات محافظت‌شده، Token رو به URL اضافه می‌کنه
    (function() {
        const urlParams = new URLSearchParams(window.location.search);
        const hasTokenInUrl = urlParams.has('token');
        
        // اگر Token در URL نیست، از localStorage بگیر
        if (!hasTokenInUrl) {
            const token = localStorage.getItem('auth_token');
            if (token) {
                // اضافه کردن Token به URL
                urlParams.set('token', token);
                const newUrl = window.location.pathname + '?' + urlParams.toString();
                
                // Redirect فقط یکبار
                if (!sessionStorage.getItem('token_added_' + window.location.pathname)) {
                    sessionStorage.setItem('token_added_' + window.location.pathname, '1');
                    window.location.replace(newUrl);
                }
            }
        }
    })();
</script>
<?php endif; ?>
```

## 🔄 جریان کار کامل

### وقتی کاربر لاگین می‌کنه:
1. کاربر در `/login.php` شماره موبایل و کد OTP را وارد می‌کند
2. `/api/verify-otp.php` Token می‌سازد و برمی‌گرداند
3. JavaScript در `login.php` Token را در localStorage ذخیره می‌کند
4. کاربر به `/dashboard.php?token=...` redirect می‌شود
5. PHP Token را از URL می‌خواند و Session را ست می‌کند ✅

### وقتی کاربر به صفحه دیگه میره:
1. کاربر روی لینک (مثلاً "eSIM های من") کلیک می‌کند
2. صفحه `/my-esims.php` شروع به لود شدن می‌کند
3. **قبل از هر چیزی**، اسکریپت در `<head>` اجرا می‌شود:
   - چک می‌کند `$requireAuth === true` هست؟ ✅ (چون `requireLogin()` صدا زده شده)
   - چک می‌کند Token در URL هست؟ ❌
   - Token را از localStorage می‌خواند ✅
   - Token را به URL اضافه می‌کند: `/my-esims.php?token=...`
   - صفحه را با URL جدید **reload** می‌کند
4. حالا PHP Token را از URL می‌خواند و Session را ست می‌کند ✅
5. کاربر **بدون نیاز به لاگین مجدد** وارد می‌شود! 🎉

## 🎯 مزایای این روش

1. **خودکار**: نیازی به تغییر دستی فایل‌ها نیست. هر صفحه که `requireLogin()` صدا بزنه، خودکار کار می‌کنه
2. **سریع**: اسکریپت در `<head>` اجرا میشه، پس خیلی زود Token رو inject می‌کنه
3. **ایمن**: Token فقط برای صفحات محافظت‌شده اضافه میشه
4. **بدون Loop**: با استفاده از sessionStorage، از infinite redirect جلوگیری می‌کنه
5. **سازگار با WebView**: در موبایل/WebView عالی کار می‌کنه

## 🧪 تست

### تست ساده:
1. برو به `/login.php` و لاگین کن
2. بعد از لاگین موفق، به `/dashboard.php` منتقل میشی
3. روی "eSIM های من" کلیک کن
4. باید **بدون درخواست لاگین مجدد** وارد بشی! ✅

### تست پیشرفته:
1. Console مرورگر رو باز کن (F12 → Console)
2. به `/dashboard.php` برو
3. localStorage رو چک کن: `localStorage.getItem('auth_token')`
4. باید Token رو ببینی ✅
5. به `/test-token-auth.php` برو تا جزئیات کامل رو ببینی

## 📝 نکات مهم

1. **فقط برای صفحات محافظت‌شده**: اسکریپت فقط وقتی اجرا میشه که `$requireAuth === true` باشه
2. **یکبار redirect**: با استفاده از sessionStorage، از redirect مکرر جلوگیری می‌کنه
3. **حفظ URL parameters**: اگر URL قبلاً parameter داشته باشه، Token به اونا اضافه میشه
4. **window.location.replace**: از `replace` استفاده میشه تا history گند نزنه

## 🚀 فایل‌های تغییر یافته

- ✅ `config/config.php` - تابع `requireLogin()` آپدیت شد
- ✅ `includes/header.php` - اسکریپت تزریق Token اضافه شد
- ✅ `login.php` - console.log برای debug اضافه شد

## 🎉 نتیجه

حالا سیستم احراز هویت **کامل و بدون مشکل** کار می‌کنه:
- ✅ Token در localStorage ذخیره میشه
- ✅ Token خودکار به URL اضافه میشه
- ✅ PHP Token رو می‌خونه و Session رو ست می‌کنه
- ✅ کاربر **هرگز** نیازی به لاگین مجدد نداره
- ✅ در موبایل/WebView عالی کار می‌کنه

---

**تاریخ**: 2025-01-13  
**نسخه**: 2.0 (راه‌حل نهایی)

