<?php
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../includes/functions.php';

requireAdmin();

$pageTitle = 'تنظیمات';
$success = '';
$error = '';

// Handle settings update
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $usdToIrr = sanitize($_POST['usd_to_irr'] ?? '');
    $zarinpalMerchant = sanitize($_POST['zarinpal_merchant'] ?? '');
    $zarinpalSandbox = isset($_POST['zarinpal_sandbox']) ? '1' : '0';
    
    if (empty($usdToIrr) || !is_numeric($usdToIrr)) {
        $error = 'لطفاً نرخ تبدیل را به صورت عددی وارد کنید.';
    } elseif (empty($zarinpalMerchant)) {
        $error = 'لطفاً Merchant ID زرین‌پال را وارد کنید.';
    } else {
        updateSetting('usd_to_irr', $usdToIrr);
        updateSetting('zarinpal_merchant', $zarinpalMerchant);
        updateSetting('zarinpal_sandbox', $zarinpalSandbox);
        
        $success = 'تنظیمات با موفقیت ذخیره شد.';
    }
}

// Get current settings
$currentUsdToIrr = getSetting('usd_to_irr', '650000');
$currentZarinpalMerchant = getSetting('zarinpal_merchant', '');
$currentZarinpalSandbox = getSetting('zarinpal_sandbox', '0');

include __DIR__ . '/../includes/header.php';
?>

<style>
@import url('https://fonts.googleapis.com/css2?family=Vazirmatn:wght@400;500;600;700;800&display=swap');

body, h1, h2, h3, h4, h5, h6, p, span, div, a, button, input, textarea, select, label, td, th {
    font-family: 'Vazirmatn', Tahoma, Arial, sans-serif !important;
}

.fas, .far, .fab, .fa {
    font-family: "Font Awesome 6 Free", "Font Awesome 6 Brands" !important;
}


.admin-container {
    display: flex;
    min-height: calc(100vh - 100px);
    gap: 0;
}

.admin-sidebar {
    width: 250px;
    background: white;
    box-shadow: 2px 0 10px rgba(0,0,0,0.1);
}

.sidebar-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 20px;
    text-align: center;
}

.sidebar-header i {
    font-size: 32px;
    margin-bottom: 10px;
}

.sidebar-header h3 {
    margin: 0;
    font-size: 18px;
}

.sidebar-menu {
    padding: 20px 0;
}

.sidebar-menu a {
    display: flex;
    align-items: center;
    gap: 12px;
    padding: 15px 20px;
    color: #666;
    text-decoration: none;
    transition: all 0.3s;
}

.sidebar-menu a:hover {
    background: #f5f5f5;
    color: #667eea;
}

.sidebar-menu a.active {
    background: #667eea;
    color: white;
    border-right: 4px solid #764ba2;
}

.sidebar-menu a i {
    width: 20px;
}

.admin-content {
    flex: 1;
    padding: 30px;
    background: #f5f7fa;
}

.page-header {
    margin-bottom: 30px;
}

.page-header h1 {
    color: #333;
    font-size: 28px;
}

.alert {
    padding: 15px 20px;
    border-radius: 8px;
    margin-bottom: 20px;
    display: flex;
    align-items: center;
    gap: 10px;
}

.alert-success {
    background: #d4edda;
    color: #155724;
    border: 1px solid #c3e6cb;
}

.alert-error {
    background: #f8d7da;
    color: #721c24;
    border: 1px solid #f5c6cb;
}

.alert-info {
    background: #d1ecf1;
    color: #0c5460;
    border: 1px solid #bee5eb;
}

.settings-container {
    background: white;
    border-radius: 12px;
    padding: 30px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.05);
}

.settings-section {
    margin-bottom: 40px;
    padding-bottom: 30px;
    border-bottom: 2px solid #f0f0f0;
}

.settings-section:last-child {
    border-bottom: none;
}

.settings-section h2 {
    color: #667eea;
    font-size: 20px;
    margin-bottom: 20px;
    display: flex;
    align-items: center;
    gap: 10px;
}

.form-group {
    margin-bottom: 20px;
}

.form-group label {
    display: block;
    margin-bottom: 8px;
    font-weight: 600;
    color: #333;
}

.form-group input[type="text"],
.form-group input[type="number"] {
    width: 100%;
    padding: 12px;
    border: 2px solid #e0e0e0;
    border-radius: 8px;
    font-size: 15px;
    transition: border 0.3s;
}

.form-group input:focus {
    outline: none;
    border-color: #667eea;
}

.form-group small {
    display: block;
    margin-top: 5px;
    color: #999;
    font-size: 13px;
}

.checkbox-label {
    display: flex;
    align-items: center;
    gap: 10px;
    cursor: pointer;
}

.checkbox-label input[type="checkbox"] {
    width: 20px;
    height: 20px;
    cursor: pointer;
}

.conversion-preview {
    background: #f8f9fa;
    padding: 15px;
    border-radius: 8px;
    margin-top: 15px;
}

.conversion-preview strong {
    display: block;
    margin-bottom: 10px;
    color: #667eea;
}

.conversion-preview p {
    margin: 5px 0;
    color: #666;
}

.form-actions {
    margin-top: 30px;
    text-align: center;
}

.btn {
    display: inline-block;
    padding: 12px 30px;
    border: none;
    border-radius: 8px;
    font-size: 16px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s;
    text-decoration: none;
}

.btn-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(102, 126, 234, 0.4);
}

.btn-large {
    padding: 15px 40px;
    font-size: 18px;
}

@media (max-width: 768px) {
    .admin-container {
        flex-direction: column;
    }
    
    .admin-sidebar {
        width: 100%;
    }
}
</style>

<div class="admin-container">
    <div class="admin-sidebar">
        <div class="sidebar-header">
            <i class="fas fa-shield-alt"></i>
            <h3>پنل مدیریت</h3>
        </div>
        <nav class="sidebar-menu">
            <a href="/admin/">
                <i class="fas fa-home"></i>
                داشبورد
            </a>
            <a href="/admin/users.php">
                <i class="fas fa-users"></i>
                کاربران
            </a>
            <a href="/admin/orders.php">
                <i class="fas fa-shopping-cart"></i>
                سفارش‌ها
            </a>
            <a href="/admin/settings.php" class="active">
                <i class="fas fa-cog"></i>
                تنظیمات
            </a>
            <a href="/">
                <i class="fas fa-arrow-left"></i>
                بازگشت به سایت
            </a>
        </nav>
    </div>

    <div class="admin-content">
        <div class="page-header">
            <h1>⚙️ تنظیمات سیستم</h1>
        </div>

        <?php if ($error): ?>
        <div class="alert alert-error">
            <i class="fas fa-exclamation-circle"></i>
            <?php echo $error; ?>
        </div>
        <?php endif; ?>

        <?php if ($success): ?>
        <div class="alert alert-success">
            <i class="fas fa-check-circle"></i>
            <?php echo $success; ?>
        </div>
        <?php endif; ?>

        <div class="settings-container">
            <form method="POST" class="settings-form">
                <div class="settings-section">
                    <h2>
                        <i class="fas fa-dollar-sign"></i>
                        تنظیمات نرخ تبدیل
                    </h2>
                    
                    <div class="form-group">
                        <label>نرخ تبدیل دلار به تومان</label>
                        <input type="number" name="usd_to_irr" 
                               value="<?php echo htmlspecialchars($currentUsdToIrr); ?>" 
                               required>
                        <small>قیمت‌های API به دلار است و با این نرخ به تومان تبدیل می‌شوند</small>
                    </div>

                    <div class="conversion-preview">
                        <strong>💡 نمونه تبدیل:</strong>
                        <p>1 دلار = <?php echo formatPrice($currentUsdToIrr); ?> تومان</p>
                        <p>10 دلار = <?php echo formatPrice($currentUsdToIrr * 10); ?> تومان</p>
                        <p>50 دلار = <?php echo formatPrice($currentUsdToIrr * 50); ?> تومان</p>
                    </div>
                </div>

                <div class="settings-section">
                    <h2>
                        <i class="fas fa-credit-card"></i>
                        تنظیمات درگاه پرداخت زرین‌پال
                    </h2>
                    
                    <div class="form-group">
                        <label>Merchant ID</label>
                        <input type="text" name="zarinpal_merchant" 
                               value="<?php echo htmlspecialchars($currentZarinpalMerchant); ?>" 
                               placeholder="XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX"
                               required>
                        <small>کد پذیرنده زرین‌پال که از پنل زرین‌پال دریافت کرده‌اید</small>
                    </div>

                    <div class="form-group">
                        <label class="checkbox-label">
                            <input type="checkbox" name="zarinpal_sandbox" 
                                   <?php echo $currentZarinpalSandbox ? 'checked' : ''; ?>>
                            <span>استفاده از Sandbox (محیط تست)</span>
                        </label>
                        <small>برای تست پرداخت فعال کنید، برای استفاده واقعی غیرفعال کنید</small>
                    </div>

                    <div class="alert alert-info">
                        <i class="fas fa-info-circle"></i>
                        <div>
                            <strong>توجه:</strong> پس از دریافت Merchant ID اصلی از زرین‌پال، حتماً گزینه Sandbox را غیرفعال کنید.
                            <br>
                            <small>⚠️ این تنظیمات فقط در دیتابیس ذخیره می‌شود. برای تغییر Merchant ID روی سرور ایران، فایل proxy-handler.php را ویرایش کنید.</small>
                        </div>
                    </div>
                </div>

                <div class="form-actions">
                    <button type="submit" class="btn btn-primary btn-large">
                        <i class="fas fa-save"></i>
                        ذخیره تنظیمات
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php include __DIR__ . '/../includes/footer.php'; ?>

