<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($pageTitle) ? $pageTitle . ' - ' : ''; ?><?php echo SITE_NAME; ?></title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="/assets/css/vazirmatn-font.css">
    <link rel="stylesheet" href="/assets/css/colors.css">
    
    <!-- Token Authentication - Sync localStorage to Cookie -->
    <script>
        (function() {
            // چک کن که آیا صفحه نیاز به Auth ندارد (مثل checkout)
            const noAuthRedirect = <?php echo (isset($noAuthRedirect) && $noAuthRedirect === true) ? 'true' : 'false'; ?>;
            
            // 1. چک token در URL
            const urlParams = new URLSearchParams(window.location.search);
            const urlToken = urlParams.get('auth_token') || urlParams.get('token');
            
            if (urlToken) {
                localStorage.setItem('auth_token', urlToken);
                document.cookie = 'auth_token=' + urlToken + '; path=/; max-age=' + (30*24*60*60) + '; SameSite=Lax';
                console.log('✅ Token از URL ذخیره شد');
            }
            
            // 2. فقط اگر noAuthRedirect نباشه، token رو sync کن
            // در صفحات checkout نباید خودکار token sync بشه
            if (!noAuthRedirect) {
                const token = localStorage.getItem('auth_token');
                if (token) {
                    document.cookie = 'auth_token=' + token + '; path=/; max-age=' + (30*24*60*60) + '; SameSite=Lax';
                    console.log('🍪 Token به Cookie sync شد');
                }
            } else {
                console.log('ℹ️ صفحه checkout - Token sync خودکار غیرفعال');
            }
            
            // 3. حذف پارامترهای اضافی از URL
            if (urlParams.has('auth_token') || urlParams.has('token') || urlParams.has('from_auth_sync')) {
                urlParams.delete('auth_token');
                urlParams.delete('token');
                urlParams.delete('from_auth_sync');
                const newUrl = window.location.pathname + 
                              (urlParams.toString() ? '?' + urlParams.toString() : '') +
                              window.location.hash;
                if (window.history && window.history.replaceState) {
                    window.history.replaceState({}, document.title, newUrl);
                }
            }
        })();
    </script>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Vazirmatn', Tahoma, Arial, sans-serif !important;
            background: #f5f5f5;
            min-height: 100vh;
            direction: rtl;
            padding-top: 70px;
        }
        
        /* Keep Font Awesome for icons */
        .fas, .far, .fab, .fa {
            font-family: "Font Awesome 6 Free", "Font Awesome 6 Brands" !important;
        }
        
        .navbar {
            background: rgba(255, 255, 255, 0.95);
            padding: 15px 0;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            z-index: 1000;
        }
        
        .navbar .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .navbar-brand {
            font-size: 24px;
            font-weight: bold;
            color: #FF2929;
            text-decoration: none;
        }
        
        .navbar-brand i {
            margin-left: 8px;
        }
        
        .navbar-menu {
            display: flex;
            gap: 25px;
            align-items: center;
            list-style: none;
        }
        
        .navbar-menu a {
            color: #333;
            text-decoration: none;
            font-weight: 500;
            transition: color 0.3s;
        }
        
        .navbar-menu a:hover {
            color: #FF2929;
        }
        
        .navbar-menu .btn {
            background: linear-gradient(135deg, #CB1919 0%, #FF2929 100%);
            color: white;
            padding: 8px 20px;
            border-radius: 6px;
            text-decoration: none;
        }
        
        .navbar-menu .btn:hover {
            background: linear-gradient(135deg, #FF2929 0%, #FF4444 100%);
            color: white;
        }
        
        .navbar-menu .user-info {
            display: flex;
            align-items: center;
            gap: 10px;
            background: #f0f0f0;
            padding: 8px 15px;
            border-radius: 6px;
        }
        
        .navbar-menu .user-info i {
            color: #FF2929;
        }
        
        /* Hamburger Menu */
        .hamburger {
            display: none;
            flex-direction: column;
            gap: 5px;
            cursor: pointer;
            padding: 10px;
            background: transparent;
            border: none;
        }
        
        .hamburger span {
            width: 30px;
            height: 3px;
            background: #FF2929;
            border-radius: 3px;
            transition: all 0.3s ease;
        }
        
        .hamburger.active span:nth-child(1) {
            transform: rotate(45deg) translate(8px, 8px);
        }
        
        .hamburger.active span:nth-child(2) {
            opacity: 0;
        }
        
        .hamburger.active span:nth-child(3) {
            transform: rotate(-45deg) translate(8px, -8px);
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 30px 20px;
        }
        
        /* Overlay for mobile menu */
        .menu-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.5);
            z-index: 998;
            opacity: 0;
            transition: opacity 0.3s ease;
        }
        
        .menu-overlay.active {
            display: block;
            opacity: 1;
        }
        
        /* نوار پایین موبایل - Bottom Navigation */
        .av-bottom-nav {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background: #FF2929;
            padding: 6px 8px 8px;
            display: none;
            justify-content: space-between;
            align-items: center;
            gap: 6px;
            z-index: 999999;
            direction: rtl;
            box-shadow: 0 -4px 10px rgba(0,0,0,0.22);
        }

        /* آیتم */
        .av-bottom-nav .nav-item {
            flex: 1;
            text-align: center;
            text-decoration: none;
        }

        /* کادر کوچک‌تر و شیک */
        .av-bottom-nav .nav-pill {
            background: rgba(255,255,255,0.10);
            border: 1px solid rgba(255,255,255,0.35);
            border-radius: 12px;
            padding: 4px 3px 5px;
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 2px;
            transition: 0.2s ease;
        }

        /* آیکون کوچک سفید */
        .av-bottom-nav .icon {
            width: 18px;
            height: 18px;
            fill: #ffffff;
        }

        /* متن سفید کوچک */
        .av-bottom-nav span {
            font-size: 10px;
            color: #ffffff;
            font-family: 'Vazirmatn', Tahoma, Arial, sans-serif !important;
        }

        /* ACTIVE */
        .av-bottom-nav .nav-item.active .nav-pill {
            background: #ffffff;
            border-color: #ffffff;
        }

        .av-bottom-nav .nav-item.active .icon {
            fill: #FF2929;
        }

        .av-bottom-nav .nav-item.active span {
            color: #FF2929;
            font-weight: 600;
        }

        /* هاور کوچک */
        .av-bottom-nav .nav-pill:hover {
            background: rgba(255,255,255,0.18);
            transform: translateY(-1px);
        }

        @media (max-width: 768px) {
            /* نمایش Bottom Nav در موبایل */
            .av-bottom-nav {
                display: flex;
            }
            
            /* اضافه کردن فضا برای Bottom Nav */
            body {
                padding-top: 60px !important;
                padding-bottom: 70px !important;
            }
            
            .navbar {
                padding: 12px 0;
            }
            
            .navbar .container {
                padding: 0 15px;
            }
            
            .navbar-brand {
                font-size: 20px;
            }
            
            .hamburger {
                display: flex;
            }
            
            .navbar-menu {
                position: fixed;
                top: 0;
                left: -100%;
                width: 280px;
                height: 100vh;
                background: white;
                flex-direction: column;
                gap: 0;
                padding: 80px 0 20px;
                box-shadow: 2px 0 15px rgba(0, 0, 0, 0.2);
                transition: left 0.3s ease;
                overflow-y: auto;
                z-index: 999;
            }
            
            .navbar-menu.active {
                left: 0;
            }
            
            .navbar-menu li {
                width: 100%;
                border-bottom: 1px solid #f0f0f0;
            }
            
            .navbar-menu a {
                display: block;
                padding: 15px 25px;
                width: 100%;
            }
            
            .navbar-menu .btn {
                margin: 10px 25px;
                width: calc(100% - 50px);
                text-align: center;
            }
            
            .navbar-menu .user-info {
                margin: 10px 25px;
                width: calc(100% - 50px);
            }
        }
    </style>
</head>
<body>
    <!-- Menu Overlay -->
    <div class="menu-overlay" id="menuOverlay" onclick="closeMenu()"></div>
    
    <nav class="navbar">
        <div class="container">
            <a href="/" class="navbar-brand">
                <i class="fas fa-sim-card"></i>
                <?php echo SITE_NAME; ?>
            </a>
            
            <!-- Hamburger Button -->
            <button class="hamburger" id="hamburger" onclick="toggleMenu()">
                <span></span>
                <span></span>
                <span></span>
            </button>
            
            <ul class="navbar-menu" id="navbarMenu">
                <li><a href="/"><i class="fas fa-home"></i> خانه</a></li>
                <?php if (isLoggedIn()): ?>
                    <?php if (isAdmin()): ?>
                        <li><a href="/admin/"><i class="fas fa-cog"></i> پنل مدیریت</a></li>
                    <?php endif; ?>
                    <li><a href="/my-esims.php"><i class="fas fa-sim-card"></i> eSIM های من</a></li>
                    <li><a href="/dashboard.php"><i class="fas fa-shopping-bag"></i> سفارشات من</a></li>
                    <li class="user-info">
                        <i class="fas fa-user"></i>
                        <span><?php echo htmlspecialchars($_SESSION['mobile']); ?></span>
                    </li>
                    <li><a href="/logout.php"><i class="fas fa-sign-out-alt"></i> خروج</a></li>
                <?php else: ?>
                    <li><a href="/login.php" class="btn">ورود / ثبت نام</a></li>
                <?php endif; ?>
            </ul>
        </div>
    </nav>
    
    <script>
        function toggleMenu() {
            const hamburger = document.getElementById('hamburger');
            const menu = document.getElementById('navbarMenu');
            const overlay = document.getElementById('menuOverlay');
            
            hamburger.classList.toggle('active');
            menu.classList.toggle('active');
            overlay.classList.toggle('active');
            
            // Prevent body scroll when menu is open
            if (menu.classList.contains('active')) {
                document.body.style.overflow = 'hidden';
            } else {
                document.body.style.overflow = '';
            }
        }
        
        function closeMenu() {
            const hamburger = document.getElementById('hamburger');
            const menu = document.getElementById('navbarMenu');
            const overlay = document.getElementById('menuOverlay');
            
            hamburger.classList.remove('active');
            menu.classList.remove('active');
            overlay.classList.remove('active');
            document.body.style.overflow = '';
        }
        
        // Close menu when clicking on a link
        document.addEventListener('DOMContentLoaded', function() {
            document.querySelectorAll('.navbar-menu a').forEach(link => {
                link.addEventListener('click', function() {
                    closeMenu();
                });
            });
        });
    </script>

