<?php
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../includes/functions.php';

requireAdmin();

$pageTitle = 'مدیریت کاربران';

// Get all users
$conn = getDBConnection();
$result = $conn->query("SELECT * FROM users ORDER BY created_at DESC");
$users = $result->fetch_all(MYSQLI_ASSOC);
$conn->close();

include __DIR__ . '/../includes/header.php';
?>

<style>
@import url('https://fonts.googleapis.com/css2?family=Vazirmatn:wght@400;500;600;700;800&display=swap');

body, h1, h2, h3, h4, h5, h6, p, span, div, a, button, input, textarea, select, label, td, th {
    font-family: 'Vazirmatn', Tahoma, Arial, sans-serif !important;
}

.fas, .far, .fab, .fa {
    font-family: "Font Awesome 6 Free", "Font Awesome 6 Brands" !important;
}


/* Same styles */
.admin-container {
    display: flex;
    min-height: calc(100vh - 100px);
    gap: 0;
}

.admin-sidebar {
    width: 250px;
    background: white;
    box-shadow: 2px 0 10px rgba(0,0,0,0.1);
}

.sidebar-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 20px;
    text-align: center;
}

.sidebar-header i {
    font-size: 32px;
    margin-bottom: 10px;
}

.sidebar-header h3 {
    margin: 0;
    font-size: 18px;
}

.sidebar-menu {
    padding: 20px 0;
}

.sidebar-menu a {
    display: flex;
    align-items: center;
    gap: 12px;
    padding: 15px 20px;
    color: #666;
    text-decoration: none;
    transition: all 0.3s;
}

.sidebar-menu a:hover {
    background: #f5f5f5;
    color: #667eea;
}

.sidebar-menu a.active {
    background: #667eea;
    color: white;
    border-right: 4px solid #764ba2;
}

.sidebar-menu a i {
    width: 20px;
}

.admin-content {
    flex: 1;
    padding: 30px;
    background: #f5f7fa;
}

.page-header {
    margin-bottom: 30px;
}

.page-header h1 {
    color: #333;
    font-size: 28px;
}

.section {
    background: white;
    border-radius: 12px;
    padding: 25px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.05);
}

.table-responsive {
    overflow-x: auto;
}

.data-table {
    width: 100%;
    border-collapse: collapse;
}

.data-table thead {
    background: #f8f9fa;
}

.data-table th {
    padding: 12px;
    text-align: right;
    font-weight: 600;
    color: #666;
    border-bottom: 2px solid #e0e0e0;
}

.data-table td {
    padding: 12px;
    text-align: right;
    border-bottom: 1px solid #f0f0f0;
}

.badge {
    padding: 5px 12px;
    border-radius: 20px;
    font-size: 12px;
    font-weight: 600;
}

.badge-admin {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
}

.badge-user {
    background: #e0e0e0;
    color: #666;
}

@media (max-width: 768px) {
    .admin-container {
        flex-direction: column;
    }
    
    .admin-sidebar {
        width: 100%;
    }
}
</style>

<div class="admin-container">
    <div class="admin-sidebar">
        <div class="sidebar-header">
            <i class="fas fa-shield-alt"></i>
            <h3>پنل مدیریت</h3>
        </div>
        <nav class="sidebar-menu">
            <a href="/admin/">
                <i class="fas fa-home"></i>
                داشبورد
            </a>
            <a href="/admin/users.php" class="active">
                <i class="fas fa-users"></i>
                کاربران
            </a>
            <a href="/admin/orders.php">
                <i class="fas fa-shopping-cart"></i>
                سفارش‌ها
            </a>
            <a href="/admin/settings.php">
                <i class="fas fa-cog"></i>
                تنظیمات
            </a>
            <a href="/">
                <i class="fas fa-arrow-left"></i>
                بازگشت به سایت
            </a>
        </nav>
    </div>

    <div class="admin-content">
        <div class="page-header">
            <h1>👥 مدیریت کاربران</h1>
        </div>

        <div class="section">
            <div class="table-responsive">
                <table class="data-table">
                    <thead>
                        <tr>
                            <th>شماره</th>
                            <th>موبایل</th>
                            <th>ایمیل</th>
                            <th>نقش</th>
                            <th>تاریخ ثبت‌نام</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($users)): ?>
                            <tr>
                                <td colspan="5" style="text-align: center; padding: 30px; color: #999;">
                                    هیچ کاربری یافت نشد
                                </td>
                            </tr>
                        <?php else: ?>
                            <?php foreach ($users as $user): ?>
                            <tr>
                                <td><strong>#<?php echo $user['id']; ?></strong></td>
                                <td><?php echo htmlspecialchars($user['mobile']); ?></td>
                                <td><?php echo htmlspecialchars($user['email']); ?></td>
                                <td>
                                    <?php if ($user['is_admin']): ?>
                                        <span class="badge badge-admin">👑 مدیر</span>
                                    <?php else: ?>
                                        <span class="badge badge-user">👤 کاربر</span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo date('Y/m/d H:i', strtotime($user['created_at'])); ?></td>
                            </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php include __DIR__ . '/../includes/footer.php'; ?>

