<?php
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../includes/functions.php';

requireLogin();

$pageTitle = 'پنل کاربری';

// Get user orders
$paidOrders = getUserOrders($_SESSION['user_id'], 'paid');
$pendingOrders = getUserOrders($_SESSION['user_id'], 'pending');

// Check for payment status messages
$paymentStatus = $_GET['payment'] ?? '';

include __DIR__ . '/../includes/header.php';
?>

<div class="container">
    <div class="dashboard-header">
        <h1>پنل کاربری</h1>
        <p>خوش آمدید، <?php echo htmlspecialchars($_SESSION['mobile']); ?></p>
    </div>

    <?php if ($paymentStatus == 'success'): ?>
    <div class="alert alert-success">
        <i class="fas fa-check-circle"></i>
        پرداخت با موفقیت انجام شد. eSIM شما در بخش "eSIM های من" قابل مشاهده است.
    </div>
    <?php elseif ($paymentStatus == 'failed'): ?>
    <div class="alert alert-error">
        <i class="fas fa-times-circle"></i>
        پرداخت ناموفق بود. لطفاً دوباره تلاش کنید.
    </div>
    <?php elseif ($paymentStatus == 'verify-failed'): ?>
    <div class="alert alert-error">
        <i class="fas fa-exclamation-triangle"></i>
        خطا در تأیید پرداخت. لطفاً با پشتیبانی تماس بگیرید.
    </div>
    <?php endif; ?>

    <div class="dashboard-grid">
        <div class="dashboard-card">
            <div class="card-icon">
                <i class="fas fa-sim-card"></i>
            </div>
            <div class="card-content">
                <h3><?php echo count($paidOrders); ?></h3>
                <p>eSIM فعال</p>
            </div>
            <a href="/user/my-esims.php" class="card-link">
                مشاهده <i class="fas fa-arrow-left"></i>
            </a>
        </div>

        <div class="dashboard-card">
            <div class="card-icon">
                <i class="fas fa-shopping-cart"></i>
            </div>
            <div class="card-content">
                <h3><?php echo count($pendingOrders); ?></h3>
                <p>سفارش در انتظار پرداخت</p>
            </div>
        </div>

        <div class="dashboard-card">
            <div class="card-icon">
                <i class="fas fa-user"></i>
            </div>
            <div class="card-content">
                <h3>پروفایل</h3>
                <p>اطلاعات کاربری</p>
            </div>
            <a href="/user/profile.php" class="card-link">
                مشاهده <i class="fas fa-arrow-left"></i>
            </a>
        </div>
    </div>

    <?php if (!empty($pendingOrders)): ?>
    <div class="section">
        <h2>سفارش‌های در انتظار پرداخت</h2>
        <div class="table-responsive">
            <table class="data-table">
                <thead>
                    <tr>
                        <th>شماره سفارش</th>
                        <th>بسته</th>
                        <th>مبلغ</th>
                        <th>تاریخ ثبت</th>
                        <th>عملیات</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($pendingOrders as $order): ?>
                    <tr>
                        <td>#<?php echo $order['id']; ?></td>
                        <td><?php echo htmlspecialchars($order['package_name']); ?></td>
                        <td><?php echo formatPrice($order['price_irr']); ?> تومان</td>
                        <td><?php echo date('Y/m/d H:i', strtotime($order['created_at'])); ?></td>
                        <td>
                            <a href="/payment.php?order=<?php echo $order['id']; ?>" class="btn btn-sm btn-primary">
                                پرداخت
                            </a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
    <?php endif; ?>

    <div class="section">
        <h2>سابقه خریدها</h2>
        <?php if (!empty($paidOrders)): ?>
        <div class="table-responsive">
            <table class="data-table">
                <thead>
                    <tr>
                        <th>شماره سفارش</th>
                        <th>بسته</th>
                        <th>کشور</th>
                        <th>مبلغ پرداختی</th>
                        <th>تاریخ خرید</th>
                        <th>کد رهگیری</th>
                        <th>وضعیت</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($paidOrders as $order): ?>
                    <tr>
                        <td>#<?php echo $order['id']; ?></td>
                        <td><?php echo htmlspecialchars($order['package_name']); ?></td>
                        <td><?php echo htmlspecialchars($order['country_name']); ?></td>
                        <td><?php echo formatPrice($order['price_irr']); ?> تومان</td>
                        <td><?php echo date('Y/m/d H:i', strtotime($order['paid_at'])); ?></td>
                        <td><?php echo htmlspecialchars($order['payment_ref_id']); ?></td>
                        <td><span class="badge badge-success">پرداخت شده</span></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        <?php else: ?>
        <div class="empty-state">
            <i class="fas fa-shopping-bag"></i>
            <p>هنوز خریدی انجام نداده‌اید.</p>
            <a href="/" class="btn btn-primary">خرید eSIM</a>
        </div>
        <?php endif; ?>
    </div>
</div>

<?php include __DIR__ . '/../includes/footer.php'; ?>